# @file			TST_accesslog_sample_code.py
# @brief		Sample program for Logitec INA Solutions's LTC-T80/LT80 Series
# @author		Logitec INA Solutions Co.,Ltd.
# @date			2021.11.10
# @version		v1.0.0
# @copyright		Logitec INA Solutions Co.,Ltd.

import requests
import json
import http.cookiejar
import time
import sys
import os
import datetime

# cookei
def save_cookies_lwp(cookiejar, filename):
    lwp_cookiejar = http.cookiejar.LWPCookieJar()
    for c in cookiejar:
        args = dict(vars(c).items())
        args['rest'] = args['_rest']
        del args['_rest']
        c = http.cookiejar.Cookie(**args)
        lwp_cookiejar.set_cookie(c)
    lwp_cookiejar.save(filename, ignore_discard=True)

def load_cookies_from_lwp(filename):
    lwp_cookiejar = http.cookiejar.LWPCookieJar()
    lwp_cookiejar.load(filename, ignore_discard=True)
    return lwp_cookiejar


# read setting json file
try:
    with open("./tst.json") as f:
        try:
            json_dict = json.load(f)
        except:
            print("json error")
            sys.exit()          
except FileNotFoundError as e:
    print("json file open error")
    sys.exit()          

ip_adr = json_dict['tst'][0]['ipadr']
user = json_dict['tst'][0]['user']
pw = json_dict['tst'][0]['pw']
path = json_dict['tst'][0]['path']

# ping    
try:
    url_get = "http://" + ip_adr + ":8080/ping"
    response = requests.get(url_get)
except:
    print("ping error")
    sys.exit()

# login
s = requests.session()
url = "http://" + ip_adr + ":8080/login"
jsonData = "{\"username\": \"" + user + "\",\"password\": \"" + pw + "\"}"
headers = {"Content-Type": "application/json"}

try:
    response = s.post(
        url,
        data=jsonData,
        headers=headers
    )
except:
    print("login error")
    sys.exit()

# save cookies
save_cookies_lwp(response.cookies, "cookie.txt")

start_time = time.time()
f_first_id = False
id_old = 0
id_latest = 0

try:
    while(1):
        # every 1s
        if (time.time() - start_time > 1.0):
            try:
                # check latest ID
                url_get = "http://" + ip_adr + ":8080/api/accesslog/id"
                response = s.get(url_get, cookies=load_cookies_from_lwp("cookie.txt"))
                data = response.json()
                id_latest = data['id']
                #print(id)

                # store first ID
                if f_first_id == False:
                    id_old = id_latest
                    f_first_id = True
            except:
                print("accesslog/id error")
                start_time = time.time()
                continue

            start_time = time.time()

        if (id_latest == id_old):
            continue
        else:
            id_old = id_latest

        # get accesslog
        url = "http://" + ip_adr + ":8080/api/accesslog"
        #jsonData = "{\"type\": \"0\",\"date\": \"2021-10-05 07:00:00\",\"id\": \"" + str(id_latest) + "\"}"  # all data
        #jsonData = "{\"type\": \"1\",\"date\": \"2021-10-05 07:00:00\",\"id\": \"" + str(id_latest) + "\"}" # lateset data
        #jsonData = "{\"type\": \"2\",\"date\": \"2021-10-05 07:00:00\",\"id\": \"" + str(id_latest) + "\"}" # date
        jsonData = "{\"type\": \"3\",\"date\": \"2021-10-05 07:00:00\",\"id\": \"" + str(id_latest) + "\"}" # ID
        headers = {"Content-Type": "application/json"}

        try:
            response = s.post(
                url,
                data=jsonData,
                headers=headers,
                cookies=load_cookies_from_lwp("cookie.txt")
            )
            data = response.json()
            #print(data)
            totalCount = data['totalCount']
            message = data['message']
            #print (message)
        except:
            print("accesslog error")
            continue

        # check parse
        for i in range(0, totalCount):
            try:
                ca = str(message[i]['created_at'])
            except KeyError:
                ca = ""
            try:
                id = str(message[i]['id'])
            except KeyError:
                id = ""
            try:
                mask = str(message[i]['mask'])
            except KeyError:
                mask = ""
            try:
                name = str(message[i]['name'])
            except KeyError:
                name = ""
            try:
                pid = str(message[i]['person_id'])
            except KeyError:
                pid = ""
            try:
                temper = str(message[i]['temperature'])
            except KeyError:
                temper = ""
            try:
                tid = str(message[i]['terminal_id'])
            except KeyError:
                tid = ""

            print ("created_at:" + ca + ", id:" + id + ", mask:" + mask + ", name:" + name + ", person_id:" + pid + ", temperature:" + temper + ", terminal_id:" + tid)
            with open(path + '\\TST_accesslog.csv','a',encoding='shift_jis') as f:
                print("created_at," + ca + ",id," + id + ",mask," + mask + ",name," + name + ",person_id," + pid + ",temperature," + temper + ",terminal_id," + tid,file=f)

# catch ctrl-c
except KeyboardInterrupt:
    # delete cookie
    os.remove('./cookie.txt')
